//=============================================================================
// AmmoShell.
//=============================================================================
class UniqueSpawn extends DeusExPickup;

var class<Weapon> Uniques[9];

function int GetLevel()
{
 local MSBorderlandsMutator M;
 local int i;
 
 forEach AllActors(class'MSBorderlandsMutator', M)
 {
  i = int(M.CurrentLevel);
  break;
 }
 
 return i;
}

function Timer()
{
 local Weapon A;
 local int i;
 
 for (i=0; i<9; i++)
 {
  A = Spawn(Uniques[i],,,Location + vect(0,0,60));
  A.SetPropertyText("WeaponLevel", String(GetLevel()));
  if (A.IsA('AtlasUnique')) AtlasUnique(A).RandomizeStats();
  if (A.IsA('DahlUnique')) DahlUnique(A).RandomizeStats();
  if (A.IsA('HyperionUnique')) HyperionUnique(A).RandomizeStats();
  if (A.IsA('JakobsUnique')) JakobsUnique(A).RandomizeStats();
  if (A.IsA('MaliwanUnique')) MaliwanUnique(A).RandomizeStats();
  if (A.IsA('SnsUnique')) SnsUnique(A).RandomizeStats();
  if (A.IsA('TedioreUnique')) TedioreUnique(A).RandomizeStats();
  if (A.IsA('TorgueUnique')) TorgueUnique(A).RandomizeStats();
  if (A.IsA('VladofUnique')) VladofUnique(A).RandomizeStats();
 }
 
 Destroy();
}

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 SetTimer(0.75, True);
}

defaultproperties
{
     InvSlotsX=0
     InvSlotsY=0
     ItemArticle=""
     ItemName="MSBorderlands Mutator Active."
     PickupMessage=""
     CollisionHeight=0
     CollisionRadius=0
     
     Uniques(0)=class'AtlasUnique'
     Uniques(1)=class'DahlUnique'
     Uniques(2)=class'HyperionUnique'
     Uniques(3)=class'JakobsUnique'
     Uniques(4)=class'MaliwanUnique'
     Uniques(5)=class'SnsUnique'
     Uniques(6)=class'TedioreUnique'
     Uniques(7)=class'TorgueUnique'
     Uniques(8)=class'VladofUnique'
}
